*******************************************************************************
*                     68000/68010 Grundprogramm speicher                      *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                        Menpunkt Speicherbereiche                           *
*******************************************************************************


getstack:                       * In a7 steht Anfangssuchadresse
 move.l a5,d0
 bsr.s getram1                  * Ram-Bereich holen
 move.l a0,d0                   * Ende des Rambereiches
 subq.l #2,d0
 and.b #$fe,d0                  * Auf geraden Wert bringen ( Zur Sicherheit )
rts                             * Ergebnis auch in d0

                                * Ram-Bereich von a0 an suchen
                                * a0 ist Such-Anfang
                                * Ergebnis a0 = Nchste Nicht-Ram-Zelle
                                *          a1 = Erste Ram-Zelle
                                * Carry dann kein Bereich vorhanden

grenze  equ     1024*1024*cpu-1024*cpu-1        * Obergrenze fr Speicher

getram:
 move.l a0,d0
getram1:
 and.w #$fc00,d0                * Auf 1 Kbyte-Grenze bringen
 movea.l d0,a0
get1ram:
 cmpa.l #grenze,a0              * 
 bhi carset                     * Wenn grer, dann Fehler
 bsr.s ramchk                   * berprfen, ob Ram
 bcc.s get2ram                  * Ja, Ram Anfang gefunden
 adda #$400,a0                  * Sonst
bra.s get1ram                   * weitersuchen

get2ram:
 movea.l a0,a1                  * Erste Ram-Zelle merken
get3ram:
 cmpa.l #grenze,a0              * Noch mal Grenze testen
 bhi carres
 bsr.s ramchk                   * Ramende suchen
 bcs carres                     * Gefunden, dann Carry = 0
 adda #$400,a0                  * Sonst weitersuchen
bra.s get3ram

ramchk:                         * Prfen, ob Ram
 movem.l d0-d3,-(a7)            * Register retten
 movem.l (a0)+,d0-d3            * Speicher retten
 move.l #$5a5a0180,-(a0)        * Speicher beschreiben
 move.l #$5a01805a,-(a0)
 move.l #$01805a5a,-(a0)
 move.l #$805a5a01,-(a0)
 cmp.l #$805a5a01,(a0)          * Jetzt berprfen, ob Werte gespeichert sind
 bne.s ramchk1                  * Nein !
 cmp.l #$01805a5a,4(a0)
 bne.s ramchk1                  * Nein !
 cmp.l #$5a01805a,8(a0)
 bne.s ramchk1                  * Nein !
 cmp.l #$5a5a0180,12(a0)
 bne.s ramchk1                  * Nein !
 movem.l d0-d3,(a0)             * OK, alle Werte gespeichert
 movem.l (a7)+,d0-d3            * Register zurck
bra carres                      * Carry = 0
ramchk1:
 movem.l (a7)+,d0-d3            * Kein Ram
bra carset                      * Carry = 1

romchk:                         * Testen, ob Rom
 movem.l d0-d3,-(a7)            * Register retten (Speicher nicht, da kein Ram)
 movem.l (a0)+,d0-d3            * Werte holen zum Vergleich
 move.l #$5a5a0180,-(a0)        * Speicher vollschreiben
 move.l #$5a01805a,-(a0)
 move.l #$01805a5a,-(a0)
 move.l #$805a5a01,-(a0)
 cmp.l (a0),d0                  * Werte mssen gleich sein, da keine
 bne.s romchk1                  * Vernderung im Eprom auftreten kann
 cmp.l 4(a0),d1
 bne.s romchk1
 cmp.l 8(a0),d2
 bne.s romchk1
 cmp.l 12(a0),d3
 bne.s romchk1                  * Werte sind gleich, also kein Ram
 cmp.l d0,d1                    * Jetzt Werte untereinander testen
 bne.s romchk0                  * Wenn gleich, dann kein Rom, da im Rom
 cmp.l d0,d2                    * normalerweise nicht 16 Werte hintereinander
 bne.s romchk0                  * gleich sind (Leeres Eprom wird nicht erkannt)
 cmp.l d0,d3
 beq.s romchk1
romchk0:
 movem.l (a7)+,d0-d3            * Ist Rom
bra carres                      * Carry lschen
romchk1:
 movem.l (a7)+,d0-d3            * Kein Rom
bra carset                      * Carry setzen

ausspber:                       * Speicherbereiche ausgeben
 lea spber1(pc),a0              * berschrift
 bsr headaclr                   * ausgeben
 lea spber2(pc),a0              * Text fr Arbeitsbereich
 moveq #$22,d0
 moveq #60,d1
 move #195,d2
 bsr textprint                  * Text ausgeben
 movea.l a5,a0                  * Beim Ram hinterm Grundprogramm anfangen
 bsr getram                     * Ram suchen
 move.l a1,d0                   * Anfang ausgeben
 move.l a0,d1                   * Ende merken
 lea ausbuf(a5),a0              * In ausbuf
 bsr print8x                    * Hexadezimal ausgeben
 move.b #'-',(a0)+              * Bis
 move.l d1,d0                   * Jetzt Ende ausgeben
 subq.l #1,d0                   * -1, da erste Nicht-Ram-Zelle angegeben war
 bsr print8x                    * Auch hexadezimal
 lea ausbuf(a5),a0              * ausbuf ausgeben
 moveq #$22,d0
 move #300,d1
 bsr textprint                  * Text ausgeben
 moveq #71,d1                   * Anfang X
 move #172,d2                   * Y-Pos
 clr d4                         * Mit Null beginnen
 moveq #16-1,d3                 * 16 Werte
ausspb1:
 move d4,d0                     * Wert holen
 lea ausbuf(a5),a0
 bsr print2x                    * In ASCII wandeln
 lea ausbuf(a5),a0
 moveq #$11,d0                  * Schriftgre
 bsr textprint                  * Ausgabe
 add #28,d1                     * Neue X-Position
 addq #2,d4                     * Nchste Spalte
dbra d3,ausspb1
 moveq #0,d3                    * Adresse
 moveq #0,d1                    * X-Pos
 move #170-8,d2                 * Jetzt erfolgt Ausgabe der Adressen an der
 moveq #16-1,d4                 * linken Seite
ausspb2:
 move.l d3,d0                   * Adresse
 lea ausbuf(a5),a0              * Ablage
 bsr print6x                    * Hexadezimal 6 Stellen
 lea ausbuf+1(a5),a0            * Aber nur 5 Stellen ausgeben
 moveq #$21,d0                  * Gre
 bsr textprint
 add.l #$1000*cpu,d3            * Nchste Adresse
 sub #10,d2                     * Y-Positon erniedrigen
dbra d4,ausspb2                 * Schleifenende
 moveq #61,d1                   * X-Anfang
 moveq #10*2,d2                 * Y-Anfang
 move #16*28+3,d3               * Breite
 move #160*2+2,d4               * Hhe
 bsr gr1p5_                     * Rechteck leer (Auf Hilfslabel springen)
 bsr wait
 move.b #25,gdp+5*cpu.w         * Gre der Linien
 suba.l a0,a0                   * Anfangsadresse = 0
 moveq #64,d1                   * Anfangsposition X
 moveq #16-1,d5                 * 16 Bnke
ausbank:
 move #170,d2                   * Y-Anfangsposition
 moveq #$10,d0                  * Befehl Linie zeichnen
 moveq #32-1,d4                 * 32 Linien pro Bank
ausreihe:
 bsr wait
 and.b #$f0, gdp+2*cpu.w        * Linien durchgezogen
 bsr ramchk                     * fr Ramtest
 bcc.s aus1reihe                * Ram, dann ausgeben
 bset.b #0,gdp+2*cpu.w          * Linien gestrichelt
 bsr romchk                     * fr Romtest
 bcs.s aus3reihe                * Fehler, dann weder Ram noch Rom
aus1reihe:
 moveq #5-1,d3
aus2reihe:
 bsr moveto
 bsr cmd                        * Linie zeichnen
 subq #1,d2                     * Neue Y-Position
dbra d3,aus2reihe
 addq #5,d2                     * d2 wieder auf alten Wert bringen
aus3reihe:
 adda #$1000,a0                 * Nchste Adresse
 subq #5,d2                     * Nchste Y-Position
dbra d4,ausreihe
 add #28,d1                     * Nchste Bank
dbra d5,ausbank
bra finmenue
                                                                                                                                                                                                                                                                                                                                                                                                                                        